//
//  PITBackup.m
//  PointInTime
//
//  Created by VA DEVELOPER on 1/11/13.
//  Copyright (c) 2013 VA. All rights reserved.
//

#import "PITBackup.h"
#import "PITItemStore.h"
#import "PITItem.h"

@implementation PITBackup

+ (BOOL) sendFile:(NSString *) sFile toUrl:(NSString *) sUrl withIdentifier: sId {

    return FALSE;
}

+ (BOOL) sendEncoded:(NSDictionary *) itemPackage toUrl:(NSString *) sUrl {
    
    /** POTENTIAL BACKUP CODE 
     
    NSURLResponse *response;
    NSError *error;
    
    NSLog(@"** ** Preparing package...");
    
    NSData *data = [NSJSONSerialization dataWithJSONObject: itemPackage options:0 error:NULL];
    
    NSMutableURLRequest *req = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:sUrl]];
    [req setHTTPMethod:@"POST"];
    [req setHTTPBody:data];
    
    NSLog(@"** ** Transmitting...");
    
    NSData *urlData = [NSURLConnection sendSynchronousRequest:req returningResponse:&response error:&error];
    NSString *getData = [[NSString alloc] initWithData: urlData encoding: NSUTF8StringEncoding];

    NSLog(@"** ** DONE\n%@", getData);
    */
    
//    return FALSE;
    NSURLResponse *response;
    NSError *error;
    int transmitCount = 0;

    NSString *deviceID = [[NSUserDefaults standardUserDefaults] objectForKey:@"PITDevicePrefKey"];
    NSLog(@"uploading record for device id: %@", deviceID);
    
    NSMutableURLRequest *req = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:sUrl]];
    [req setValue:@"application/x-www-form-urlencoded" forHTTPHeaderField:@"content-type"];
    [req setValue:@"UTF-8" forHTTPHeaderField:@"charset"];
    
    [req setHTTPMethod:@"POST"];
    for (PITItem *item in [[PITItemStore sharedStore] allItems]) {
        //  NSString* str = @"state=GA&city=Atlanta&address=Five+Points&loc_Accuracy=67.89&loc_Longitude=23.23&loc_Latitude=45.45&chronic=false&deviceID=987098qwe7rqwer&age=67&gender=M&lastName=Woo&middleName=Man&firstName=Fu&surveyDateTime=928304750&surveyRecordID=imarecordid43";
        
        NSString* str = [NSString stringWithFormat:@"state=%@&city=%@&address=%@&loc_Accuracy=%f&loc_Longitude=%f&loc_Latitude=%f&chronic=%@&deviceID=%@&age=%d&gender=%@&lastName=%@&middleName=%@&firstName=%@&surveyDateTime=%.0f&surveyRecordID=%@",
                         [item itemState] ? [item itemState] : @"",
                         [item itemCity] ? [item itemCity] : @"",
                         [item itemFreeLocation] ? [item itemFreeLocation] : @"",
                         [item itemAccuracy],
                         [item itemLongitude],
                         [item itemLatitude],
                         [item itemChronic] ? @"true" : @"false",
                         deviceID,
                         [item itemAge],
                         [item itemGender],
                         [item itemLastName] ? [item itemLastName] : @"",
                         [item itemMiddleName] ? [item itemMiddleName] : @"",
                         [item itemFirstName] ? [item itemFirstName] : @"",
                         [[item dateCreated] timeIntervalSince1970] * 1000,     //convert to milliseconds since 1970
                         [item itemID]];
        
        NSData* data = [str dataUsingEncoding:NSUTF8StringEncoding];
        [req setHTTPBody:data];
        NSLog(@"Posting: %@", str);
        NSData *urlData = [NSURLConnection sendSynchronousRequest:req returningResponse:&response error:&error];
        NSString *getData = [[NSString alloc] initWithData: urlData encoding: NSUTF8StringEncoding];
        if ([getData isEqualToString:@"\"success\""])
            transmitCount++;
        NSLog(@"** POST result: %@, error: %@", getData, [error description]);
//        sleep(1);
    }
    
    int totalCount = [[[PITItemStore sharedStore] allItems] count];
    if (totalCount > 0) {
        NSString *resultMsg;
        if (transmitCount == totalCount) {
            resultMsg = @"Everything uploaded successfully.";
        } else {
            resultMsg = [NSString stringWithFormat:@"%d of %d records uploaded successfully.", transmitCount, totalCount];
        }
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Upload Result"
                                                        message:resultMsg
                                                       delegate:nil
                                              cancelButtonTitle:@"OK"
                                              otherButtonTitles:nil];
        [alert show];
    }
    
    return TRUE;
}


@end
